% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{vertex_attr}
\alias{vertex_attr}
\alias{vertex.attributes}
\title{Query vertex attributes of a graph}
\usage{
vertex_attr(graph, name, index = V(graph))
}
\arguments{
\item{graph}{The graph.}

\item{name}{Name of the attribute to query. If missing, then
all vertex attributes are returned in a list.}

\item{index}{An optional vertex sequence to query the attribute only
for these vertices.}
}
\value{
The value of the vertex attribute, or the list of
all vertex attributes, if \code{name} is missing.
}
\description{
Query vertex attributes of a graph
}
\examples{
g <- make_ring(10) \%>\%
  set_vertex_attr("color", value = "red") \%>\%
  set_vertex_attr("label", value = letters[1:10])
vertex_attr(g, "label")
vertex_attr(g)
plot(g)
}
\seealso{
Vertex, edge and graph attributes
\code{\link{delete_edge_attr}()},
\code{\link{delete_graph_attr}()},
\code{\link{delete_vertex_attr}()},
\code{\link{edge_attr}()},
\code{\link{edge_attr<-}()},
\code{\link{edge_attr_names}()},
\code{\link{graph_attr}()},
\code{\link{graph_attr<-}()},
\code{\link{graph_attr_names}()},
\code{\link{igraph-attribute-combination}},
\code{\link{igraph-dollar}},
\code{\link{igraph-vs-attributes}},
\code{\link{set_edge_attr}()},
\code{\link{set_graph_attr}()},
\code{\link{set_vertex_attr}()},
\code{\link{vertex_attr<-}()},
\code{\link{vertex_attr_names}()}
}
\concept{attributes}
