% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centrality.R
\name{alpha_centrality}
\alias{alpha_centrality}
\alias{alpha.centrality}
\title{Find Bonacich alpha centrality scores of network positions}
\usage{
alpha_centrality(
  graph,
  nodes = V(graph),
  alpha = 1,
  loops = FALSE,
  exo = 1,
  weights = NULL,
  tol = 1e-07,
  sparse = TRUE
)
}
\arguments{
\item{graph}{The input graph, can be directed or undirected. In undirected
graphs, edges are treated as if they were reciprocal directed ones.}

\item{nodes}{Vertex sequence, the vertices for which the alpha centrality
values are returned. (For technical reasons they will be calculated for all
vertices, anyway.)}

\item{alpha}{Parameter specifying the relative importance of endogenous
versus exogenous factors in the determination of centrality. See details
below.}

\item{loops}{Whether to eliminate loop edges from the graph before the
calculation.}

\item{exo}{The exogenous factors, in most cases this is either a constant --
the same factor for every node, or a vector giving the factor for every
vertex. Note that too long vectors will be truncated and too short vectors
will be replicated to match the number of vertices.}

\item{weights}{A character scalar that gives the name of the edge attribute
to use in the adjacency matrix. If it is \code{NULL}, then the
\sQuote{weight} edge attribute of the graph is used, if there is one.
Otherwise, or if it is \code{NA}, then the calculation uses the standard
adjacency matrix.}

\item{tol}{Tolerance for near-singularities during matrix inversion, see
\code{\link[=solve]{solve()}}.}

\item{sparse}{Logical scalar, whether to use sparse matrices for the
calculation. The \sQuote{Matrix} package is required for sparse matrix
support}
}
\value{
A numeric vector contaning the centrality scores for the selected
vertices.
}
\description{
\code{alpha_centrality()} calculates the alpha centrality of some (or all)
vertices in a graph.
}
\details{
The alpha centrality measure can be considered as a generalization of
eigenvector centrality to directed graphs. It was proposed by Bonacich in
2001 (see reference below).

The alpha centrality of the vertices in a graph is defined as the solution
of the following matrix equation: \deqn{x=\alpha A^T x+e,}{x=alpha t(A)x+e,}
where \eqn{A}{A} is the (not necessarily symmetric) adjacency matrix of the
graph, \eqn{e}{e} is the vector of exogenous sources of status of the
vertices and \eqn{\alpha}{alpha} is the relative importance of the
endogenous versus exogenous factors.
}
\section{Warning}{
 Singular adjacency matrices cause problems for this
algorithm, the routine may fail is certain cases.
}

\examples{

# The examples from Bonacich's paper
g.1 <- make_graph(c(1, 3, 2, 3, 3, 4, 4, 5))
g.2 <- make_graph(c(2, 1, 3, 1, 4, 1, 5, 1))
g.3 <- make_graph(c(1, 2, 2, 3, 3, 4, 4, 1, 5, 1))
alpha_centrality(g.1)
alpha_centrality(g.2)
alpha_centrality(g.3, alpha = 0.5)

}
\references{
Bonacich, P. and Lloyd, P. (2001). ``Eigenvector-like
measures of centrality for asymmetric relations'' \emph{Social Networks},
23, 191-201.
}
\seealso{
\code{\link[=eigen_centrality]{eigen_centrality()}} and \code{\link[=power_centrality]{power_centrality()}}

Centrality measures
\code{\link{closeness}()},
\code{\link{diversity}()},
\code{\link{eigen_centrality}()},
\code{\link{estimate_betweenness}()},
\code{\link{harmonic_centrality}()},
\code{\link{hub_score}()},
\code{\link{page_rank}()},
\code{\link{power_centrality}()},
\code{\link{spectrum}()},
\code{\link{strength}()},
\code{\link{subgraph_centrality}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{centrality}
\keyword{graphs}
