% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structural.properties.R
\name{girth}
\alias{girth}
\title{Girth of a graph}
\usage{
girth(graph, circle = TRUE)
}
\arguments{
\item{graph}{The input graph. It may be directed, but the algorithm searches
for undirected circles anyway.}

\item{circle}{Logical scalar, whether to return the shortest circle itself.}
}
\value{
A named list with two components: \item{girth}{Integer constant, the
girth of the graph, or 0 if the graph is acyclic.} \item{circle}{Numeric
vector with the vertex ids in the shortest circle.}
}
\description{
The girth of a graph is the length of the shortest circle in it.
}
\details{
The current implementation works for undirected graphs only, directed graphs
are treated as undirected graphs. Loop edges and multiple edges are ignored.
If the graph is a forest (ie. acyclic), then zero is returned.

This implementation is based on Alon Itai and Michael Rodeh: Finding a
minimum circuit in a graph \emph{Proceedings of the ninth annual ACM
symposium on Theory of computing}, 1-10, 1977. The first implementation of
this function was done by Keith Briggs, thanks Keith.
}
\examples{

# No circle in a tree
g <- make_tree(1000, 3)
girth(g)

# The worst case running time is for a ring
g <- make_ring(100)
girth(g)

# What about a random graph?
g <- sample_gnp(1000, 1 / 1000)
girth(g)

}
\references{
Alon Itai and Michael Rodeh: Finding a minimum circuit in a
graph \emph{Proceedings of the ninth annual ACM symposium on Theory of
computing}, 1-10, 1977
}
\seealso{
Other structural.properties: 
\code{\link{bfs}()},
\code{\link{component_distribution}()},
\code{\link{connect}()},
\code{\link{constraint}()},
\code{\link{coreness}()},
\code{\link{degree}()},
\code{\link{dfs}()},
\code{\link{diameter}()},
\code{\link{distance_table}()},
\code{\link{edge_density}()},
\code{\link{feedback_arc_set}()},
\code{\link{is_matching}()},
\code{\link{knn}()},
\code{\link{laplacian_matrix}()},
\code{\link{reciprocity}()},
\code{\link{subcomponent}()},
\code{\link{subgraph}()},
\code{\link{topo_sort}()},
\code{\link{transitivity}()},
\code{\link{unfold_tree}()},
\code{\link{which_multiple}()},
\code{\link{which_mutual}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{structural.properties}
\keyword{graphs}
