% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/m_value.R
\name{m_value}
\alias{m_value}
\title{Calculate the M-value}
\usage{
m_value(data, r = 90)
}
\arguments{
\item{data}{DataFrame object with column names "id", "time", and "gl",
or numeric vector of glucose values.}

\item{r}{A reference value corresponding to basal glycemia in normal
subjects; default is 90 mg/dL.}
}
\value{
If a data.frame object is passed, then a tibble object with
two columns: subject id and corresponding M-value is returned. If a vector of glucose
values is passed, then a tibble object with just the M-value is returned.
as.numeric() can be wrapped around the latter to output just a numeric value.
}
\description{
Calculates the M-value of Schlichtkrull et al. (1965) for
each subject in the data, where the M-value is the mean of the logarithmic
transformation of the deviation from a reference value. Produces a tibble
object with subject id and M-values.
}
\details{
A tibble object with 1 row for each subject, a column for subject id and
a column for the M-values is returned. NA glucose values are
omitted from the calculation of the M-value.

M-value is computed by averaging the transformed glucose values, where each
transformed value is equal to \eqn{|1000 * log_10(glucose/100)|^3}
}
\examples{
data(example_data_5_subject)

m_value(example_data_5_subject)
m_value(example_data_5_subject, r = 100)

}
\references{
Schlichtkrull J, Munck O, Jersild M. (1965) The M-value, an index of
blood-sugar control in diabetics.
\emph{Acta Medica Scandinavica} \strong{177} .95-102.
\doi{10.1111/j.0954-6820.1965.tb01810.x}.
}
