`qqig` <-
function(x,kernel="normal",line=FALSE,
xlab='Empirical quantiles',ylab='Theoretical quantiles'){
ker<-kernel
estimados<-mleig(x,kernel=ker)
a<-estimados$mu
b<-estimados$lambda
c<-estimados$nu
nu<-c
n<-length(x)
k<-seq(1,n,by=1)
P<-(k-0.5)/n
if(kernel=="normal"){
Finv<-qig(P,mu=a,lambda=b,kernel="normal")
}
if(kernel=="t"){
Finv<-qig(P,mu=a,lambda=b,kernel="t",parameter.nu=c)
}
if(kernel=="logistic"){
Finv<-qig(P,mu=a,lambda=b,kernel="logistic")
}
if(kernel=="Laplace"){
Finv<-qig(P,mu=a,lambda=b,kernel="Laplace")
}
quantile<-sort(x)
plot(quantile,Finv,xlab=xlab,ylab=ylab,col=4,lwd=1.5)
R<-((cor(quantile,Finv))^2)*100
text(median(quantile),max(Finv),as.expression(substitute(R^2==r,list(r=R))))
Result<-list(coefficient.determination=R)
if(line==TRUE){
quant<-quantile(x)
x1<-quant[2]
x2<-quant[4]
y1<-qig(0.25,a,b,kernel=ker,nu)
y2<-qig(0.75,a,b,kernel=ker,nu)
m<-((y2-y1)/(x2-x1))
inter<-y1-(m*x1)
abline(inter,m,col=2,lwd=2.0)
}
}

