% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guess_fc.R
\name{guess_fc}
\alias{guess_fc}
\title{Guess Italian Fiscal Code}
\usage{
guess_fc(surname = NULL, name = NULL, birth_date = NULL, female = NULL,
  codice_catastale = NULL)
}
\arguments{
\item{surname}{character, surname}

\item{name}{character, names}

\item{birth_date}{Date, date of birth}

\item{female}{logical, female indicator variable (\code{FALSE} = man,
\code{TRUE} = woman)}

\item{codice_catastale}{Italian 'codice catastale' (an identifier) of
the 'comune' of birth}
}
\value{
The function return a character vector of fiscal code.
}
\description{
The function tries to guess regular fiscal code, extracting relevant
alphanumeric digits from surname, name, birth date, gender and 'codice
catastale' (computing the last character, the control digit).
}
\examples{

## using fictious data
Surnames <- c("Rossi", "Bianchi")
Names <- c("Mario", "Giovanna")
Birthdates <- as.Date(c("1960-01-01", "1970-01-01"))
Female <- c(FALSE, TRUE)
Comune_of_birth <- c("F205", # milan
                     "H501") # rome
guess_fc(Surnames, Names, Birthdates, Female, Comune_of_birth)

}

