% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AgivenFcont.R
\encoding{UTF-8}
\name{AgivenFcont}
\alias{AgivenFcont}
\title{Annual value given Future value [continuous] (Engineering Economics)}
\usage{
AgivenFcont(F, n, r)
}
\arguments{
\item{F}{numeric vector that contains the future value(s)}

\item{n}{numeric vector that contains the period value(s)}

\item{r}{numeric vector that contains the continuously compounded nominal
annual interest rate(s) as a percent}
}
\value{
AgivenFcont numeric vector that contains the annual value(s)
   rounded to 2 decimal places
}
\description{
Compute A given F with interest compounded continuously
}
\details{
A is expressed as

	\deqn{A = F\left[\frac{e^{r} - 1}{e^{rn} - 1}\right]}

\describe{
\item{\emph{A}}{the "annual equivalent amount (occurs at the end of
    each year)"}
\item{\emph{F}}{the "future equivalent"}
\item{\emph{r}}{the "nominal annual interest rate, compounded
    continuously"}
\item{\emph{n}}{the "number of periods (years)"}
}
}
\examples{

library(iemisc)

AgivenFcont(300, 2, 11) # 11\\% interest




}
\references{
William G. Sullivan, Elin M. Wicks, and C. Patrick Koelling, \emph{Engineering Economy}, Fourteenth Edition, Upper Saddle River, New Jersey: Pearson/Prentice Hall, 2009, page 169.
}
\author{
Irucka Embry
}
