% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_norm_dist_from_ci.R
\name{estimate_norm_dist_from_ci}
\alias{estimate_norm_dist_from_ci}
\title{A Function to Estimate a Normal Distribution from Credible or Confidence Intervals}
\usage{
estimate_norm_dist_from_ci(lower_interval = NULL,
  upper_interval = NULL, interval = "95\%")
}
\arguments{
\item{lower_interval}{Numeric, the lower CI.}

\item{upper_interval}{Numeric, the upper CI}

\item{interval}{A character string indicating the percentage interval the CI represents. Defaults to "95\%".}
}
\value{
A dataframe containing the mean and standard deviation of the normal distribution summarised by the provided CI's.
}
\description{
A Function to Estimate a Normal Distribution from Credible or Confidence Intervals
}
\examples{

## Run function to estimate normal distribution for a 95\% CI of 1, to 2

df <- estimate_norm_dist_from_ci(1,2)

## Check

x <- rnorm(10000, df$mean, df$sd)

quantile(x, c(0.025, 0.975))
}
