% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markposDFs.R
\docType{data}
\name{markposDFs}
\alias{markposDFs}
\alias{bigdfOfMarks}
\alias{dfOfMarks}
\alias{dfOfMarks2}
\alias{humMarkPos}
\alias{allMarksSample}
\alias{dfAlloParentMarks}
\alias{traspaMarks}
\title{Mark Positional data - monocentrics}
\format{
bigdfOfMarks a data.frame with columns:
\describe{
\item{OTU}{OTU, species, mandatory if in dfChrSize}
\item{chrName}{name of chromosome}
\item{markName}{name of mark}
\item{chrRegion}{use p for short arm, q for long arm, and cen for
centromeric}
\item{markDistCen}{distance of mark to centromere (not for cen)}
\item{markSize}{size of mark (not for cen)}
}

An object of class \code{data.frame} with 4 rows and 5 columns.

An object of class \code{data.frame} with 6 rows and 5 columns.

An object of class \code{data.frame} with 395 rows and 5 columns.

An object of class \code{data.frame} with 43 rows and 6 columns.

An object of class \code{data.frame} with 15 rows and 4 columns.

An object of class \code{data.frame} with 18 rows and 7 columns.
}
\source{
\href{http://www.pathology.washington.edu/research/cytopages/idiograms/human/}{Washington U}
}
\usage{
bigdfOfMarks

dfOfMarks

dfOfMarks2

humMarkPos

allMarksSample

dfAlloParentMarks

traspaMarks
}
\description{
When several OTUs, some can be monocen. and others holocen.
Marks distance for
monocen. are measured from cen. and for
holocen. from top or bottom depending on \code{param} \code{origin}. See
vignettes.

bigdfOfMarks: Example data for mark position with column OTU

dfOfMarks: Example data for marks' position

dfOfMarks2: Marks' position including cen. marks

humMarkPos: human karyotype bands' (marks) positions, measured
from Adler (1994)

allMarksSample: Example data for marks' position

dfAlloParentMarks: Example data for mark position of GISH of
monocen.

traspaMarks: T. spathacea (Rhoeo) marks' positions, from
Golczyk et al. (2005)
}
\references{
Adler 1994. Idiogram Album. URL:
\href{http://www.pathology.washington.edu/research/cytopages/idiograms/human/}{Washington U.}

Golczyk H, Hasterok R, Joachimiak AJ (2005) FISH-aimed
karyotyping and
characterization of Renner complexes in permanent heterozygote Rhoeo
spathacea. Genome
48:145–153.
}
\seealso{
\code{\link{markdataholo}}

\code{\link{plotIdiograms}}

\code{\link{chrbasicdatamono}}

\code{\link{dfMarkColor}}
}
\keyword{datasets}
