% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idem_visualize.R
\name{plotContour}
\alias{plotContour}
\title{Contour plot of the sensitivity analysis results}
\usage{
plotContour(rst.final, lst.var, con.v = 0.05, nlevels = 30, ...)
}
\arguments{
\item{rst.final}{A class \code{IDEM.TEST} list generated by
\code{\link{get.overall.rst}}}

\item{lst.var}{see \code{\link{idem-parameters}}}

\item{con.v}{Levels of contour plot}

\item{nlevels}{Levels of color scale}

\item{...}{Options for \code{filled.contour}}
}
\description{
Generate contour plot of p-values for sensitivity analysis results
}
\examples{

\dontrun{
lst.var <- list(trt="TRT", surv="SURV", outcome=c("Y1","Y2"), y0=NULL,
                endp=c("Y2"), unitTime="days",
                trt.label = c("UC+SBT", "SAT+SBT"),
                cov=c("AGE"), endfml="Y2", duration=365, bounds=c(0,100));
rst.fit <- fit.model(abc, lst.var);
rst.imp <- get.imp.all(abc, rst.fit, lst.var, deltas=c(-0.25,0,0.25),
                       normal=TRUE, iter=300, n.imp=2, thin=10, p.scale=10);
rst.est <- get.theta.quantiles(rst.imp, lst.var,
                               quantiles=c(0.25,0.5,0.75));
rst.boot <- get.bs.all(n.boot = 10, n.cores = 5, data.all = abc,
                       lst.var = lst.var, deltas = c(-0.25, 0, 0.25),
                       quantiles = c(0.25,0.5,0.75), normal=TRUE,
                       iter=300, n.imp=2, thin=10, p.scale=10);

rst.final <- get.overall.rst(rst.est, rst.boot);
plotContour(rst.final, lst.var, con.v=0.05, nlevels = 30);
}

}

