% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idem_visualize.R
\name{plotComposite}
\alias{plotComposite}
\title{Cumulative Plot}
\usage{
plotComposite(imp.data, lst.var, delta = 0, buffer = 0.05, at.surv = NULL,
  at.z = NULL, p.death = NULL, seg.lab = c("Survival", "Functional"),
  fname = NULL, cols = rep(c("cyan", "red"), 3), ltys = rep(1, 6),
  main = "", ...)
}
\arguments{
\item{imp.data}{A class \code{IDEM.IMP} dataframe containing complete data
with relevant missing values imputed. See \code{\link{get.imp.all}}.}

\item{lst.var}{see \code{\link{idem-parameters}}}

\item{delta}{Imputation sensitivity parameter for which to generate the results}

\item{buffer}{Small horizontal gap used to better visually distinguish the
transition from survival to functional outcome.}

\item{at.surv}{Sets the range of the survival times to plot in the cumulative distribution function.
By default the range is the range of survival values up to the duration of the study.}

\item{at.z}{Sets the range of the functional outcome to plot in the cumulative distribution function.
By defualt this is the range of the functional outcomes plus the buffer amount to improve visibility
in the transition from survival to functional outcome.}

\item{p.death}{Proportion of the plot width devoted to Survival. By default the
cumulative distribution will devote horizontal space to the survival portion that
is proportional to the number of subjects who die prior to duration.}

\item{seg.lab}{Labels for the two components of the composite outcome.}

\item{fname}{File name of the result pdf file. If \code{fname} is null,
result pdf file will not be generated}

\item{cols}{\code{plot} options}

\item{ltys}{\code{plot} options}

\item{main}{\code{plot} options}

\item{...}{Options for \code{pdf} function}
}
\description{
Generate cumulative plot of the composite survival and functional outcome
}
\examples{
\dontrun{
lst.var <- list(trt="TRT", surv="SURV", outcome=c("Y1","Y2"), y0=NULL,
                endp=c("Y2"), unitTime="days",
                trt.label = c("UC+SBT", "SAT+SBT"),
                cov=c("AGE"), endfml="Y2", duration=365, bounds=c(0,100));
rst.fit <- fit.model(abc, lst.var);
rst.imp <- get.imp.all(abc, rst.fit, lst.var, deltas=c(-0.25,0,0.25),
                       normal=TRUE, iter=300, n.imp=2, thin=10, p.scale=10);

plotComposite(rst.imp, lst.var, delta=0);}
}

