% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idem_analysis.R
\name{get.overall.rst}
\alias{get.overall.rst}
\title{Hypothesis testing}
\usage{
get.overall.rst(rst.org, rst.boot, quantiles = c(0.025, 0.975))
}
\arguments{
\item{rst.org}{A class \code{IDEM.RST} result list from
\code{\link{get.theta.quantiles}} using the original data}

\item{rst.boot}{A class \code{IDEM.BOOT} result list from
\code{\link{get.theta.quantiles}} using the original data}

\item{quantiles}{Quantiles for extracting bootstrap confidence intervals}
}
\value{
A class \code{IDEM.TEST} containing two datasets

\describe{

\item{theta}{ With columns

\itemize{

\item \code{Delta0}: Sensitivity parameter for control arm,
\item \code{Delta1}: Sensitivity parameter for intervention arm
\item \code{Theta}: Estimated \eqn{\theta}
\item \code{SD}: Standard deviation
\item \code{PValue}: p-value
}}

\item{quantiles}{With columns

\itemize{

\item \code{Delta}:Sensitivity parameter
\item \code{TRT}:Treatment arm
\item \code{Q}: Quantiles of the composite endpoint to be estimated
\item \code{Quant}: Estimation
\item \code{LB}: Lower bound of the specified confidence interval
\item \code{UB}: Upper bound of the specified confidence interval
}}
}
}
\description{
Hypothesis testing using the estimation for the original dataset and
Summarize Boostrap analysis results
}
\examples{
\dontrun{
lst.var <- list(trt="TRT", surv="SURV", outcome=c("Y1","Y2"), y0=NULL,
                endp=c("Y2"), unitTime="days",
                trt.label = c("UC+SBT", "SAT+SBT"),
                cov=c("AGE"), endfml="Y2", duration=365, bounds=c(0,100));
rst.fit <- fit.model(abc, lst.var);
rst.imp <- get.imp.all(abc, rst.fit, lst.var, deltas=c(-0.25,0,0.25),
                       normal=TRUE, iter=300, n.imp=2, thin=10, p.scale=10);
rst.est <- get.theta.quantiles(rst.imp, lst.var,
                               quantiles=c(0.25,0.5,0.75));
rst.boot <- get.bs.all(n.boot = 10, n.cores = 5, data.all = abc,
                       lst.var = lst.var, deltas = c(-0.25, 0, 0.25),
                       quantiles = c(0.25,0.5,0.75), normal=TRUE,
                       iter=300, n.imp=2, thin=10, p.scale=10);

rst.final <- get.overall.rst(rst.est, rst.boot);}
}

