% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid-resample.R, R/data-facelayer-resample.R
\docType{data}
\name{resample}
\alias{resample}
\alias{resample,Raster,trigrid-method}
\alias{resample,facelayer,trigrid-method}
\title{Resampling of data involving a \code{\link{trigrid}} or a \code{\link{hexagrid}} object.}
\format{
An object of class \code{standardGeneric} of length 1.
}
\usage{
resample

\S4method{resample}{Raster,trigrid}(x, y, method = "ngb", na.rm = TRUE)

\S4method{resample}{facelayer,trigrid}(x, y, method = NULL, res = 5)
}
\arguments{
\item{x}{(\code{\link[raster:raster]{RasterLayer}}, \code{\link{facelayer}}) Object to resample.}

\item{y}{(\code{\link{hexagrid}} or \code{\link{trigrid}}) Object describing the target structure.}

\item{method}{(\code{character}) The name of the algorithm used for resampling.}

\item{na.rm}{(\code{logical}) If a face contains a missing value, should its value be \code{NA} as well (\code{FALSE}) or calculate the mean anyway (\code{TRUE}).}

\item{res}{(\code{numeric}) Value indicating the precision of area estimation during the upscaling (\code{facelayer}-method). In case the \code{"ebaa"} method is chosen, the variable indicate the number of breaking points on an edge.}
}
\value{
A named \code{numeric} vector.
}
\description{
The function is used to resolve and resample data stored in \code{RasterLayer}s and \code{\link{facelayer}}s so they can be fitted to and can be plotted by using \code{\link{trigrid}} or \code{\link{hexagrid}} objects.

The function applies different resampling algorithms. Currently there are only two implemented methods, one for upscaling and one for downscaling. The downscaling method "average" will tabluate all face centers from the high resolution grid that fall on a coarse resolution cell and average them. The upscaling method "ebaa" (edge breakpoint area approximation) will estimate the areas covered by the high resolution cells using the number of edge breakpoints.
}
\details{
This method is necessary to utilize rasterized data in the \code{\link{icosa}} package. The only method currently implemented upscales the raster data and then resolves the values to the \code{\link{trigrid}} or \code{\link{hexagrid}} values, using averages. In the case of resampling \code{\link[raster:raster]{RasterLayer}}s, the \code{method} argument will be passed to the \code{\link[raster]{resample}} function.
}
\examples{
# create a grid
g <- trigrid(c(4,4))
# create a data layer
fl <- facelayer(g)
fl@values<-rnorm(length(fl))
# target structure
h <- trigrid(4)
# resampling
res <- resample(fl, h)
fl2<-facelayer(h)
fl2@values[] <- res

}
\keyword{datasets}
