% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_id_weib.R
\name{sim_id_weib}
\alias{sim_id_weib}
\title{Simulate panel data from an illness-death model with Weibull transition hazards}
\usage{
sim_id_weib(
  n,
  n_obs,
  stop_time,
  eval_times,
  start_state = c("stable", "equalprob"),
  shape,
  scale,
  ...
)
}
\arguments{
\item{n}{Number of subjects to generate paths for.}

\item{n_obs}{Number of observations in time period for each subject.}

\item{stop_time}{Largest time at which the model is considered.}

\item{eval_times}{A function which returns the evaluation times for a subject.
Must have as arguments at least \code{n_obs} and \code{stop_time}.}

\item{start_state}{In which states can subjects start? Either everyone starts 
in state 1 ("stable") or equal probability to start in state 1 or 2 ("equalprob").}

\item{shape}{Vector of shape parameters for the 3 transitions. See \code{\link[stats:rweibull]{rweibull}}.
The first entry will be used for the first transition and so on.}

\item{scale}{Vector of scale parameters for the 3 transitions. See \code{\link[stats:rweibull]{rweibull}}
The first entry will be used for the first transition and so on.}

\item{...}{Further parameters to \code{eval_times} function.}
}
\value{
Panel data in the form of a \code{data.frame} with 3 named columns
 id, time and state. These represent the subject identifier, the observation
 time and the state at the 
observation time.
}
\description{
An illness-death model has 3 transitions:
\describe{
\item{\code{1}:}{State 1 (Healthy) to State 2 (Illness);}
\item{\code{2}:}{State 1 (Healthy) to State 3 (Death);}
\item{\code{3}:}{State 2 (Illness) to State 3 (Death);}
}
Using this function, it is possible to simulate data from an illness-death 
model with Weibull transition intensities. Requires the use of an external 
(self-written) function to generate observation times.
}
\details{
Taking \code{shape = 1} we get an exponential distribution with rate
\code{1/scale}
}
\examples{
#Function to generate evaluation times: at 0 and uniform inter-observation
eval_times <- function(n_obs, stop_time){
  cumsum( c( 0,  runif( n_obs-1, 0, 2*(stop_time-4)/(n_obs-1) ) ) )
}

#Simulate illness-death model data with Weibull transitions
sim_dat <- sim_id_weib(n = 20, n_obs = 6, stop_time = 15, eval_times = eval_times,
start_state = "stable", shape = c(0.5, 0.5, 2), scale = c(5, 10, 10/gamma(1.5)))

visualise_msm(sim_dat)

}
