% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkInputs.R
\name{checkSurveyYearOK}
\alias{checkSurveyYearOK}
\title{Check that a survey and year combination is in the database}
\usage{
checkSurveyYearOK(survey, year, checksurvey = TRUE)
}
\arguments{
\item{survey}{the survey acronym, e.g. NS-IBTS.}

\item{year}{the year of the survey, e.g. 2010.}

\item{checksurvey}{logical, should the survey name also be checked.}
}
\value{
logical.
}
\description{
Checks a year and/or survey name against a list of all survey year combinations in the DATRAS database.
If the combination is not matched it puts up a message showing the available options.
}
\examples{
\dontrun{
checkSurveyYearOK(survey = "ROCKALL", 2015)
checkSurveyYearOK(survey = "ROCKALL", 2000)
checkSurveyYearOK(survey = "NOTALL", 2000)
}
}
\seealso{
\code{\link{checkSurveyOK}} and \code{\link{checkSurveyYearQuarterOK}}
 also perform checks against the DATRAS database.

\code{\link{icesDatras-package}} gives an overview of the package.
}
