% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explain.R
\name{icd9Explain}
\alias{icd9Explain}
\alias{icd9Explain.character}
\alias{icd9Explain.factor}
\alias{icd9Explain.list}
\alias{icd9Explain.numeric}
\alias{icd9ExplainDecimal}
\alias{icd9ExplainShort}
\title{explain ICD9 codes}
\usage{
icd9Explain(icd9, isShort = icd9GuessIsShort(icd9), doCondense = TRUE,
  brief = FALSE, warn = TRUE)

icd9ExplainShort(icd9Short, doCondense = TRUE, brief = FALSE, warn = TRUE)

icd9ExplainDecimal(icd9Decimal, doCondense = TRUE, brief = FALSE,
  warn = TRUE)

\method{icd9Explain}{list}(icd9, isShort = icd9GuessIsShort(icd9),
  doCondense = TRUE, brief = FALSE, warn = TRUE)

\method{icd9Explain}{factor}(icd9, isShort = icd9GuessIsShort(icd9),
  doCondense = TRUE, brief = FALSE, warn = TRUE)

\method{icd9Explain}{character}(icd9, isShort = icd9GuessIsShort(icd9),
  doCondense = TRUE, brief = FALSE, warn = TRUE)

\method{icd9Explain}{numeric}(icd9, isShort = icd9GuessIsShort(icd9),
  doCondense = TRUE, brief = FALSE, warn = FALSE)
}
\arguments{
\item{icd9}{is
a character vector or factor of ICD-9 codes. If fewer than five characters
is given in a code, then the digits are greedily assigned to hundreds, then
tens, then units, before the decimal parts. E.g. "10" becomes "010", not
"0010".}

\item{isShort}{single logical value which determines whether the ICD-9 code
provided is in short (TRUE) or decimal (FALSE) form. Where reasonable, this
is guessed from the input data.}

\item{doCondense}{single logical value which indicates whether to condense
the given set of ICD-9 codes by replacing subsets of codes with 'parent'
codes which exactly encompass certain subsets. E.g. If all cholera
diagnoses are provided, only '001 - Cholera' needs to be displayed, not all
subtypes.}

\item{brief}{single logical value, default is \code{FALSE}. If \code{TRUE},
the short description from the canonical CMS descriptions (included in
\code{extdata}) will be used, otherwise the long description is used.}

\item{warn}{single logical value, default is \code{TRUE}, meaning that codes
which do not correspond to diagnoses, or to three-digit codes, will trigger
a warning.}

\item{icd9Short}{is a character vector of ICD-9 codes. If fewer than
five characters is given in a code, then the digits are greedily assigned
to hundreds, then tens, then units, before the decimal parts. E.g. "10"
becomes "010", not "0010"}

\item{icd9Decimal}{character vector of ICD-9 codes. If fewer than five
characters is given in a code, then the digits are greedily assigned to
hundreds, then tens, then units, before the decimal parts. E.g. "10"
becomes "010", not "0010"}
}
\value{
data frame, or list of data frames, with fields for ICD9 code, name
  and description, derived from datamart lookup table
}
\description{
convert 'decimal' format (123.45 style) ICD9 codes into the name and
  description for human review there are official ICD9-CM data tables, not
  with conversion to decimal notation, but to the textual format.
}
\section{Methods (by class)}{
\itemize{
\item \code{list}: explain all ICD-9 codes in a list of vectors

\item \code{factor}: explain factor of ICD-9 codes

\item \code{character}: explain character vector of ICD-9 codes

\item \code{numeric}: explain numeric vector of ICD-9 codes, with warning.
In general, this is not allowed because of the possible ambiguity of
numeric decimal codes, but for convenience, this is allowed in this case to
avoid typing many quotes.
}}
\examples{
icd9ExplainShort(ahrqComorbid[[1]][1:3])
icd9Explain(ahrqComorbid[[1]][1:3], brief = TRUE)
}
\seealso{
package comorbidities
}

