% Generated by roxygen2 (4.0.1): do not edit by hand
\name{icd9ValidDecimal}
\alias{icd9ValidDecimal}
\alias{icd9ValidDecimalE}
\alias{icd9ValidDecimalN}
\alias{icd9ValidDecimalV}
\title{check whether decimal icd9 codes are valid}
\usage{
icd9ValidDecimal(icd9Decimal)

icd9ValidDecimalV(icd9Decimal)

icd9ValidDecimalE(icd9Decimal)

icd9ValidDecimalN(icd9Decimal)
}
\arguments{
\item{icd9Decimal}{character vector of ICD-9 codes. If fewer than five characters is given in a
code, then the digits are greedily assigned to hundreds, then tens, then
units, before the decimal parts. E.g. "10" becomes "010", not "0010"}
}
\value{
logical vector with T or F for each icd9 code provided according to
  validity
}
\description{
Check validity of 'long' (i.e. decimal form) ICD9 codes. The
  codes may be numeric disease descriptiors or V or E prefixed.
}
\details{
Long form is not ambiguous so additional zeroes are tolerated.
  Although integer ICD-9 codes could be correct, there is a difference
  between 100 and 100.0, and indeed 100.00. Therefore, character class is
  enforced to avoid this problem.
}
\note{
TODO: icd9ValidDecimalN not quite right, since it would validate 0.12
}
\seealso{
\url{http://www.stata.com/users/wgould/icd9/icd9.hlp}
  url{http://www.sascommunity.org/wiki/Validate_the_format_of_ICD-9_codes}

Other ICD9 validation: \code{\link{icd9GetInvalidMappingDecimal}},
  \code{\link{icd9GetInvalidMappingShort}},
  \code{\link{icd9ValidMapping}},
  \code{\link{icd9ValidMappingDecimal}},
  \code{\link{icd9ValidMappingShort}};
  \code{\link{icd9ValidMajor}},
  \code{\link{icd9ValidMajorE}},
  \code{\link{icd9ValidMajorN}},
  \code{\link{icd9ValidMajorV}};
  \code{\link{icd9ValidNaWarnStop}},
  \code{\link{icd9ValidNaWarnStopDecimal}},
  \code{\link{icd9ValidNaWarnStopMajor}},
  \code{\link{icd9ValidNaWarnStopShort}};
  \code{\link{icd9ValidShort}},
  \code{\link{icd9ValidShortE}},
  \code{\link{icd9ValidShortN}},
  \code{\link{icd9ValidShortV}}; \code{\link{icd9Valid}};
  \code{\link{stopIfInvalidIcd9}},
  \code{\link{warnIfInvalidIcd9}}
}

