% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_plots.R
\name{distribution_plot}
\alias{distribution_plot}
\alias{density_plot}
\title{Plot Density and Distribution Function With Markings}
\usage{
distribution_plot(
  fun,
  range,
  ...,
  points = NULL,
  var = "x",
  title = "Verteilungsfunktion",
  is_discrete = NULL
)

density_plot(
  fun,
  range,
  ...,
  from = NULL,
  to = NULL,
  points = NULL,
  var = "x",
  title = "Dichte",
  is_discrete = NULL
)
}
\arguments{
\item{fun}{a density or distribution function that takes
quantiles as its first argument.}

\item{range}{numeric vector of length two giving the
range of quantiles to be plotted.}

\item{...}{further arguments that are passed to \code{fun()}.}

\item{points}{numeric vector giving quantiles where the
function should be marked with a red dot (continuous) or a red bar
(discrete).}

\item{var}{character giving the name of the quantile
variable. This is only used to label the axes.}

\item{title}{character giving the title of the plot}

\item{is_discrete}{logical indicating whether this is a discrete distribution.
For discrete distributions, a bar plot is created. If omitted, the function
tries to automatically determine, whether the distributions is discrete.
In case this should fail, set this argument explicitly.}

\item{from, to}{numeric values giving start and end of a
range where the area under the density will be shaded (continuous)
or the bars will be drawn in red (discrete).
If only one of the two values is given, the shading
will start at negative infinity or go until positive infinity,
respectively.}
}
\value{
a \code{ggplot} object
}
\description{
Create plots of the density and distribution functions
of a probability distribution. It is possible to
mark points and shade the area under the curve.
}
\examples{
# plot density of the normal distribution
density_plot(dnorm, c(-5, 7),
             mean = 1, sd = 2,
             to = 3)

# plot distribution function of the Poisson distribution
distribution_plot(ppois, c(0, 12),
                  lambda = 4,
                  points = c(2, 6, 10),
                  var = "y")

}
