% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iaibase.R
\name{get_survival_curve_data}
\alias{get_survival_curve_data}
\title{Extract the underlying data from a survival curve (as returned by
\code{\link{predict.survival_learner}}
or
\code{\link{get_survival_curve}})}
\usage{
get_survival_curve_data(curve)
}
\arguments{
\item{curve}{The curve to query.}
}
\description{
The data is returned as a list with two keys: \code{times} containing the
time for each breakpoint on the curve, and \code{coefs} containing the
probability for each breakpoint on the curve.
}
\details{
Julia Equivalent:
\href{https://docs.interpretable.ai/v3.1.0/IAIBase/reference/#IAI.get_survival_curve_data}{\code{IAI.get_survival_curve_data}}
}
\examples{
\dontrun{iai::get_survival_curve_data(curve)}

}
