% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/false_ring_proportion.R
\name{campelo_chapman}
\alias{campelo_chapman}
\title{campelo_chapman}
\usage{
campelo_chapman(
  campelo_freq_object,
  min.n = 15,
  start = NULL,
  make.plot = TRUE,
  max.iter = 500,
  ...
)
}
\arguments{
\item{campelo_freq_object}{a campelo frequency object,
output of \code{\link[iadf]{campelo_freq}}}

\item{min.n}{minimum number of samples within each group to be included in
model estimation}

\item{start}{set custom start values - default to
\code{list(a = 0.8, b = 0.03, c = 12.5)}}

\item{make.plot}{logical}

\item{max.iter}{maximum iterations for internally used
\code{\link[stats]{nls}}}

\item{...}{additional plotting arguments}
}
\value{
a model object of class "nls"
}
\description{
Chapman model fitting to size classes for the calculation of
size corrected IADF frequencies according to Campelo et al. (2015).
}
\examples{
data('example_iadf')
data('example_rwl')
model <- campelo_chapman(campelo_freq(example_iadf, example_rwl))
campelo_index(example_iadf, example_rwl, model)
}
\references{
Campelo, F., Vieira, J., Battipaglia, G. et al. Which matters most for the
  formation of intra-annual density fluctuations in Pinus pinaster: age or
  size? Trees (2015) 29: 237. doi:10.1007/s00468-014-1108-9
}
\seealso{
\code{\link{campelo_freq}}, \code{\link{campelo_index}}
}
