% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_summarize_png_metadata.R
\name{ifcb_summarize_png_metadata}
\alias{ifcb_summarize_png_metadata}
\title{Summarize PNG Image Metadata}
\usage{
ifcb_summarize_png_metadata(
  png_folder,
  feature_folder = NULL,
  hdr_folder = NULL
)
}
\arguments{
\item{png_folder}{Character. The file path to the folder containing the PNG images.}

\item{feature_folder}{Character. The file path to the folder containing the feature files (optional).}

\item{hdr_folder}{Character. The file path to the folder containing the header files (optional).}
}
\value{
A dataframe that joins image data, header data, and feature data based on the sample and roi number.
}
\description{
This function processes IFCB data by reading images, matching them to the corresponding
header and feature files, and joining them into a single dataframe. This function may be
useful when preparing metadata files for an Ecotaxa submission.
}
\examples{
\dontrun{
png_folder <- "path/to/pngs"
feature_folder <- "path/to/features"
hdr_folder <- "path/to/hdr_data"
result_df <- ifcb_summarize_png_metadata(png_folder, feature_folder, hdr_folder)
}

}
