% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_psd_plot.R
\name{ifcb_psd_plot}
\alias{ifcb_psd_plot}
\title{Generate PSD Plot for a Given Sample}
\usage{
ifcb_psd_plot(sample_name, data, fits, start_fit)
}
\arguments{
\item{sample_name}{The name of the sample to plot in DYYYYMMDDTHHMMSS.}

\item{data}{A data frame containing the PSD data (data output from \code{ifcb_psd}), where each row represents a sample and each column represents different particle sizes in micrometers.}

\item{fits}{A data frame containing the fit parameters for the power curve (fits output from \code{ifcb_psd}), where each row represents a sample and the columns include the parameters \code{a}, \code{k}, and \code{R2}.}

\item{start_fit}{The x-value threshold below which data should be excluded from the plot and fit.}
}
\value{
A ggplot object representing the PSD plot for the sample.
}
\description{
This function generates a plot for a given sample from Particle Size Distribution (PSD) data and fits from Imaging FlowCytobot (IFCB).
The PSD data and fits can be generated by \code{ifcb_psd} (Hayashi et al. in prep).
}
\examples{
\dontrun{
# Analyze PSD
psd <- ifcb_psd(feature_folder = 'path/to/features',
                hdr_folder = 'path/to/hdr_data',
                save_data = TRUE,
                output_file = 'psd/svea_2021',
                plot_folder = NULL,
                use_marker = FALSE,
                start_fit = 13,
                r_sqr = 0.5,
                beads = 10 ** 9,
                bubbles = 150,
                incomplete = c(1500, 3),
                missing_cells = 0.7,
                biomass = 1000,
                bloom = 5,
                humidity = NULL)

# Plot PSD of the first sample
plot <- ifcb_psd_plot(sample_name = "D20230316T101514",
                      data = psd$data,
                      fits = psd$fits,
                      start_fit = 10)
# Inspect plot
print(plot)
}
}
\references{
Hayashi, K., Walton, J., Lie, A., Smith, J. and Kudela M. Using particle size distribution (PSD) to automate imaging flow cytobot (IFCB) data quality in coastal California, USA. In prep.
}
\seealso{
\code{\link{ifcb_psd}} \url{https://github.com/kudelalab/PSD}
}
