% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_get_runtime.R
\name{ifcb_get_runtime}
\alias{ifcb_get_runtime}
\title{Read IFCB Header File and Extract Runtime Information}
\usage{
ifcb_get_runtime(hdr_file)
}
\arguments{
\item{hdr_file}{A character string specifying the full path to the .hdr file or URL.}
}
\value{
A list (hdr) containing runtime, inhibittime, and runType (if available) extracted from the header file.
}
\description{
This function imports an IFCB header file (either from a local path or URL),
extracts specific target values such as runtime and inhibittime,
and returns them in a structured format (in seconds). This is
the R equivalent function of \code{IFCBxxx_readhdr} from the \code{ifcb-analysis} repository (Sosik and Olson 2007).
}
\examples{
\dontrun{
# Example: Read and extract information from an IFCB header file
hdr_info <- ifcb_get_runtime("path/to/IFCB_hdr_file.hdr")
print(hdr_info)
}
}
\references{
Sosik, H. M. and Olson, R. J. (2007), Automated taxonomic classification of phytoplankton sampled with imaging-in-flow cytometry. Limnol. Oceanogr: Methods 5, 204–216.
}
\seealso{
\url{https://github.com/hsosik/ifcb-analysis}
}
