/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

import java.util.Arrays;
import umontreal.iro.lecuyer.hups.PointSet;
import umontreal.iro.lecuyer.hups.RadicalInverse;

public class HaltonSequence
extends PointSet {
    private int[] base;
    private int[][] permutation;
    private boolean permuted;
    private RadicalInverse[] radinv;
    private int[] start;
    private static final int positiveBitMask = ~Integer.reverse(1);

    public HaltonSequence(int dim) {
        if (dim < 1) {
            throw new IllegalArgumentException("Halton sequence must have positive dimension dim");
        }
        this.dim = dim;
        this.numPoints = Integer.MAX_VALUE;
        this.base = RadicalInverse.getPrimes(dim);
        this.start = new int[dim];
        Arrays.fill(this.start, 0);
    }

    public void setStart(double[] x0) {
        for (int i = 0; i < this.dim; ++i) {
            this.start[i] = RadicalInverse.radicalInverseInteger(this.base[i], x0[i]);
        }
    }

    public void init(double[] x0) {
        this.radinv = new RadicalInverse[this.dim];
        for (int i = 0; i < this.dim; ++i) {
            this.radinv[i] = new RadicalInverse(this.base[i], x0[i]);
        }
    }

    public void addFaureLemieuxPermutations() {
        this.permutation = new int[this.dim][];
        for (int i = 0; i < this.dim; ++i) {
            this.permutation[i] = new int[this.base[i]];
            RadicalInverse.getFaureLemieuxPermutation(i, this.permutation[i]);
        }
        this.permuted = true;
    }

    public void addFaurePermutations() {
        this.permutation = new int[this.dim][];
        for (int i = 0; i < this.dim; ++i) {
            this.permutation[i] = new int[this.base[i]];
            RadicalInverse.getFaurePermutation(this.base[i], this.permutation[i]);
        }
        this.permuted = true;
    }

    public void ErasePermutations() {
        this.permuted = false;
        this.permutation = null;
    }

    public int getNumPoints() {
        return Integer.MAX_VALUE;
    }

    public double getCoordinate(int i, int j) {
        if (this.radinv != null) {
            if (!this.permuted) {
                return this.radinv[j].nextRadicalInverse();
            }
            throw new UnsupportedOperationException("Fast radical inverse is not implemented in case of permutation");
        }
        int k = this.start[j] + i;
        if (k < 0) {
            k = (k & positiveBitMask) + 1;
        }
        if (this.permuted) {
            return RadicalInverse.permutedRadicalInverse(this.base[j], this.permutation[j], k);
        }
        return RadicalInverse.radicalInverse(this.base[j], k);
    }
}

