% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/break_down_uncertainty.R
\name{break_down_uncertainty}
\alias{break_down_uncertainty}
\alias{break_down_uncertainty.explainer}
\alias{break_down_uncertainty.default}
\alias{shap}
\title{Explanation Level Uncertainty of Sequential Variable Attribution}
\usage{
break_down_uncertainty(x, ..., B = 10)

\method{break_down_uncertainty}{explainer}(x, new_observation, ...,
  B = 10)

\method{break_down_uncertainty}{default}(x, data,
  predict_function = predict, new_observation, label = class(x)[1],
  ..., path = NULL, B = 10)

shap(x, ..., B = 25)
}
\arguments{
\item{x}{a model to be explained, or an explainer created with function `DALEX::explain()`.}

\item{...}{other parameters.}

\item{B}{number of random paths}

\item{new_observation}{a new observation with columns that correspond to variables used in the model.}

\item{data}{validation dataset, will be extracted from `x` if it is an explainer.}

\item{predict_function}{predict function, will be extracted from `x` if it is an explainer.}

\item{label}{name of the model. By default it's extracted from the 'class' attribute of the model.}

\item{path}{if specified, then this path will be highlighed on the plot. Use `average` in order to show an average effect}
}
\value{
an object of the `break_down_uncertainty` class.
}
\description{
The `break_down_uncertainty()` calles `B` times the break down algorithm for random orderings.
Then it calculated distribution of attributions for these different orderings.
Note that the `shap()` function is just a simplified interface to the `break_down_uncertainty()` function
with by default `B=25` random draws.
}
\examples{
library("DALEX")
library("iBreakDown")
# Toy examples, because CRAN angels ask for them
titanic <- na.omit(titanic)
set.seed(1313)
titanic_small <- titanic[sample(1:nrow(titanic), 500), c(1,2,6,9)]
model_titanic_glm <- glm(survived == "yes" ~ gender + age + fare,
                       data = titanic_small, family = "binomial")
explain_titanic_glm <- explain(model_titanic_glm,
                           data = titanic_small[,-9],
                           y = titanic_small$survived == "yes")

# there is no explanation level uncertanity linked with additive models
bd_rf <- break_down_uncertainty(explain_titanic_glm, titanic_small[1, ])
bd_rf
plot(bd_rf)

\donttest{
## Not run:
library("randomForest")
set.seed(1313)
model <- randomForest(status ~ . , data = HR)
new_observation <- HR_test[1,]

explainer_rf <- explain(model,
                        data = HR[1:1000, 1:5])

bd_rf <- break_down_uncertainty(explainer_rf,
                           new_observation)
bd_rf
plot(bd_rf)

# example for regression - apartment prices
# here we do not have intreactions
model <- randomForest(m2.price ~ . , data = apartments)
explainer_rf <- explain(model,
                        data = apartments_test[1:1000, 2:6],
                        y = apartments_test$m2.price[1:1000])

bd_rf <- break_down_uncertainty(explainer_rf, apartments_test[1,])
bd_rf
plot(bd_rf)

bd_rf <- break_down_uncertainty(explainer_rf, apartments_test[1,], path = 1:5)
plot(bd_rf)

bd_rf <- break_down_uncertainty(explainer_rf,
                                     apartments_test[1,],
                                     path = c("floor", "no.rooms", "district",
                                         "construction.year", "surface"))
plot(bd_rf)

bd_rf <- shap(explainer_rf,
              apartments_test[1,])
bd_rf
plot(bd_rf)
plot(bd_rf, show_boxplots = FALSE)
}
}
\references{
Predictive Models: Visual Exploration, Explanation and Debugging \url{https://pbiecek.github.io/PM_VEE}
}
\seealso{
\code{\link{break_down}}, \code{\link{local_attributions}}
}
