% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/pages.R
\name{add_page}
\alias{add_page}
\alias{remove_page}
\alias{add_page,i2dashboard-method}
\alias{remove_page,i2dashboard-method}
\title{Methods to add and remove pages of an \linkS4class{i2dashboard} object.}
\usage{
add_page(dashboard, ...)

remove_page(dashboard, page)

\S4method{add_page}{i2dashboard}(
  dashboard,
  page,
  title,
  layout = "default",
  menu = NULL,
  sidebar = NULL,
  ...
)

\S4method{remove_page}{i2dashboard}(dashboard, page)
}
\arguments{
\item{dashboard}{A \linkS4class{i2dashboard}.}

\item{...}{Additional arguments.}

\item{page}{The name of the page to be added or removed.}

\item{title}{The title of the page to be added.}

\item{layout}{The page layout (see below).}

\item{menu}{The name of the menu, under which the page should appear.}

\item{sidebar}{A Markdown string. Preferably, use the function '\code{add_to_sidebar()}'.}
}
\value{
Returns the \linkS4class{i2dashboard} object with a modified 'pages' slot.
}
\description{
'\code{add_page()}' creates a page and adds it to the \linkS4class{i2dashboard} object.
'\code{remove_page()}' removes a page from the \linkS4class{i2dashboard} object.
}
\examples{
i2dashboard() \%>\%
     add_page(page="page1",
         title="Page Title",
         layout = "2x2_grid",
         menu="Menu A") -> dashboard
dashboard \%<>\% remove_page(page="page1")
}
