% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypergate.R
\name{hypergate}
\alias{hypergate}
\title{hypergate}
\usage{
hypergate(xp, gate_vector, level, delta_add = 0, beta = 1, verbose = FALSE)
}
\arguments{
\item{xp}{an Expression matrix}

\item{gate_vector}{A Categorical vector of length nrow(xp)}

\item{level}{A level of gate_vector so that gate_vector == level will produce a boolean vector identifying events of interest}

\item{delta_add}{If the increase in F after an optimization loop is lower than delta_add, the optimization will stop (may save computation time)}

\item{beta}{Purity / Yield trade-off}

\item{verbose}{Boolean. Whether to print information about the optimization status.}
}
\description{
Finds a hyperrectangle gating around a population of interest
}
\examples{
data(Samusik_01_subset)
xp=Samusik_01_subset$xp_src[,Samusik_01_subset$regular_channels]
gate_vector=Samusik_01_subset$labels
hg=hypergate(xp=xp,gate_vector=gate_vector,level=23,delta_add=0.01)
}
\seealso{
\code{\link{channels_contributions}} for ranking parameters within the output, \code{\link{reoptimize_strategy}} for reoptimizing a output on a subset of the markers, \code{\link{plot_gating_strategy}} for plotting an output, \code{\link{subset_matrix_hg}} to apply the output to another input matrix, \code{\link{boolmat}} to obtain a boolean matrix stating which events are filtered out because of which markers
}
