% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/costDEA.R
\name{costDEA}
\alias{costDEA}
\title{Cost DEA model}
\usage{
costDEA(X, Y, pX, RTS = "crs")
}
\arguments{
\item{X}{Vector, matrix or dataframe with DMUs as rows and inputs as columns}

\item{Y}{Vector, matrix or dataframe with DMUs as rows and outputs as columns}

\item{pX}{Vector, matrix or dataframe with prices for each DMU and input.
Therefore it must have the same dimensions as X.}

\item{RTS}{Character string indicating the returns-to-scale, e.g. "crs", "vrs".}
}
\value{
A list object containing the following:
\item{lambdas}{Estimated values for the composition of the respective Benchmarks. The lambdas are stored in a matrix with dimensions nrow(X) x nrow(X), where the row is the DMU under observation and the columns are the peers used for the Benchmark.}
\item{opt_value}{Optimal inputs.}
\item{cost_eff}{Cost efficiency as the ratio of the optimal cost to the observed cost.}
}
\description{
Cost DEA model optimizing the input allocation with given prices.
It returns the estimated lambdas as well as the optimal values for inputs and a cost efficiency score
that is the ratio of optimal costs over observed costs.
}
\examples{
X <- matrix(c(1,2,3,3,2,1,2,2), ncol = 2)
Y <- matrix(c(1,1,1,1), ncol = 1)

pX <- matrix(c(2,1,2,1,2,1,1,2), ncol =  2, byrow = TRUE)


cost_eff_input <- costDEA(X,Y,pX)

}
\seealso{
[Benchmarking::cost.opt] for a similar function
}
