%% File lhoat.Rd
%% Part of the hydroPSO R package, http://www.rforge.net/hydroPSO/ ; 
%%                                 http://cran.r-project.org/web/packages/hydroPSO
%% Copyright 2011-2012 Mauricio Zambrano-Bigiarini & Rodrigo Rojas
%% Distributed under GPL 2 or later

\name{lhoat}
\alias{lhoat}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Latin-Hypercube One-factor-At-a-Time
}
\description{
This function implements the Latin-Hypercube One-factor-At-a-Time procedure developed by van Griensven et al., (2006) for sensitivity analysis of model parameters 
}
\usage{
lhoat(fn="hydromod", lower=-Inf, upper=Inf, control=list(),
      model.FUN=NULL, model.FUN.args=list() )
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{fn}{
character, name of a valid R function to be analysed or the character value \sQuote{hydromod}. \cr
-) When \code{fn!='hydromod'}, the first argument of \code{fn} has to be a vector of parameters over which the analysis is going to take place. It should return a scalar result. When \code{fn!='hydromod'} the algorithm uses the value(s) returned by \code{fn} as both model output and its corresponding goodness-of-fit measure \cr
-) When \code{fn=='hydromod'} the algorithm will analyse the model defined by \code{model.FUN} and \code{model.args}, which are used to extract the values simulated by the model and to compute its corresponding goodness-of-fit measure
}
%%\item{\dots}{
%%further arguments to be passed to \code{fn}
%%}
  \item{lower}{
numeric, lower boundary for each parameter \cr
Note for \code{\link[stats]{optim}} users: in \kbd{hydroPSO} the length of \code{lower} and \code{upper} are used to defined the dimension of the solution space
}
  \item{upper}{
numeric, upper boundary for each parameter \cr
Note for \code{\link[stats]{optim}} users: in \kbd{hydroPSO} the length of \code{lower} and \code{upper} are used to defined the dimension of the solution space
}
  \item{control}{
a list of control parameters. See \sQuote{Details}
}
  \item{model.FUN}{
OPTIONAL. Used only when \code{fn='hydromod'} \cr
character, valid R function representing the model code to be calibrated/optimised
} 
  \item{model.FUN.args}{
OPTIONAL. Used only when \code{fn='hydromod'} \cr
list with the arguments to be passed to \code{model.FUN}
} 
}
\details{

The \code{control} argument is a list that can supply any of the following components:
  \describe{  
      
  \item{N}{
numeric, number of strata to be used for sampling the range, as provided in \code{params.ranges}, for each parameter
}
  \item{f}{
numeric, fraction of the parameter's range by which each single parameter of the initial LHS is changed within the Morris OAT design
}
  \item{drty.in}{
character, path to the directory storing the input files required for PSO, i.e. \sQuote{ParamRanges.txt} and \sQuote{ParamFiles.txt}
}
  \item{drty.out}{
character, path to the directory storing the output files generated by \kbd{hydroPSO}
}
  \item{param.ranges}{
OPTIONAL. Used only when \code{fn='hydromod'} \cr
character, name of the file storing the desired range of variation of each parameter
} 
  \item{digits}{
OPTIONAL. Used only when \code{write2disk=TRUE} \cr
numeric, number of significant digits used for writing the outputs in scientific notation
}
  \item{gof.name}{
character, ONLY used for identifying the goodness-of-fit of each model run and writing it to the \kbd{LH_OAT-gof.txt} output file
}
  \item{do.plots}{
logical, if TRUE a PNG plot with the comparison between observed and simulated values is produced for each parameter set used in the LH-OAT
}
  \item{write2disk}{
logical, indicates if the output files will be written to the disk 
}
  \item{verbose}{
logical, if TRUE progress messages are printed
}
%%  \item{\dots}{
%%     ~~Describe \code{\dots} here~~
%%}
  }
}
\value{
A list of two elements: \cr 
\item{ParameterSets}{a matrix with all the parameter sets used in the LH-OAT}
\item{Ranking}{a dataframe with a ranking, parameter id, and relative importance indicator for each parameter, sorted in decreasing order of importance}
}
\references{
\cite{A. van Griensven, T. Meixner, S. Grunwald, T. Bishop, M. Diluzio, R. Srinivasan, A global sensitivity analysis tool for the parameters of multi-variable catchment models, Journal of Hydrology, Volume 324, Issues 1-4, 15 June 2006, Pages 10-23, DOI: 10.1016/j.jhydrol.2005.09.008.}
}
\author{
Mauricio Zambrano-Bigiarini, \email{mzb.devel@gmail.com}
}
%%\note{
%%  ~~further notes~~
%%}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{hydroPSO}}, \code{\link{hydromod}}
}
\examples{

# Number of dimensions to be optimised
nparam <- 5

# Running the Latin-Hypercube One-factor-At-a-Time sensitivity analysis.
# Dummy case, because for this test function all the parameters have the
# same sensitivity
\dontrun{
lhoat(
      fn=sphere, 
      lower=rep(-100,nparam), 
      upper=rep(100,nparam),
      control=list(N=10, f=0.1, write2disk=TRUE)
      
      )

# Plotting dotty plots      
read_params(file="LH_OAT-gof.txt", header=TRUE, skip=0, param.cols=2:(nparam+1),
            of.col=1, of.name="sphere", ptype="dottyplot")
}      

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{manip}
\keyword{math}% __ONLY ONE__ keyword per line
