% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/baseflowB.R
\name{baseflowB}
\alias{baseflowB}
\title{Baseflow removal (after Ladson et al)}
\usage{
baseflowB(q, alpha = 0.925, passes = 3, r = 30)
}
\arguments{
\item{q}{The vector series of streamflow}

\item{alpha}{Filter parameter}

\item{passes}{Number of passes}

\item{r}{number of points reflected at start and end of data set}
}
\value{
A list of the baseflow and baseflow index at each timestep.
}
\description{
This function calculates baseflow using a recursive digital filter and is based on
the implementation described in Ladson et al (2013).
}
\details{
The reflected points act to resolve spin up issues and are removed before the baseflow is removed.
}
\examples{
library(hydroEvents)
data(dataBassRiver)
alpha.list = c(0, 0.9, 0.925, 0.95, 0.98, 0.987)
BFI = numeric(length(alpha.list))
for (i in 1:length(alpha.list)) {
  bf = baseflowB(dataBassRiver, alpha = alpha.list[i])
  BFI[i] = sum(bf$bf)/sum(dataBassRiver)
}
print(cbind(alpha.list, BFI))
}
\references{
Ladson, A., Brown, R., Neal, B., & Nathan, R. (2013). A standard approach to baseflow separation using the Lyne and Hollick filter.
Australian Journal of Water Resources, 17(1).
}
\keyword{baseflow}
