% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MethCl_CS_Arbitrary.R
\name{mean_roughness}
\alias{mean_roughness}
\alias{mean_roughness,CSarbitrary-method}
\title{Mean Roughness}
\usage{
mean_roughness(object, h)
}
\arguments{
\item{object}{A CSarbitrary object.}

\item{h}{A numeric vector of water levels [m].}
}
\value{
A numeric vector representing the mean roughness for the given water
 levels.
}
\description{
Calculates the mean roughness of a CSarbitrary object for a
 given
  set of water levels, based on Einstein (1934).
}
\examples{
# Example usage:
x <- c(0, 4, 9, 13)
z <- c(2, 0, 0, 2)
cs <- CSarbitrary(x = x, z = z, xb_l = 4, xb_r = 9, kSt_B = 35,
                  kSt_l = 45, kSt_r = 45)
h_levels <- c(1, 2)  # water levels
mean_roughness(cs, h_levels)
}
