% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WaterLevelDataFrame-methods.R
\name{names<-,WaterLevelDataFrame,character-method}
\alias{names<-,WaterLevelDataFrame,character-method}
\title{Set names of a WaterLevelDataFrame}
\usage{
\S4method{names}{WaterLevelDataFrame,character}(x) <- value
}
\arguments{
\item{x}{an object of class \linkS4class{WaterLevelDataFrame}.}

\item{value}{a character vector of up to the same length as \code{ncol(x)}.
Since the names of the first three columns of an object of class
\linkS4class{WaterLevelDataFrame} are predetermined (\code{"station",
"station_int", "w"}) only the later names of additional columns can be
modified.}
}
\value{
For \code{names}, a character vector of the same length as
  \code{ncol(x)}.

  For \code{names<-}, the updated object. (Note that the value of
  \code{names(x) <- value} is that of the assignment, \code{value}, not the
  return value from the left-hand side.)
}
\description{
Function to get or set the column names of an object of class
  \linkS4class{WaterLevelDataFrame}.
}
\note{
To access the slot names of an object of class
  \linkS4class{WaterLevelDataFrame} the function
  \code{\link[methods:slot]{slotNames}} has to be used.
}
\examples{
wldf <- WaterLevelDataFrame(river   = "Elbe",
                            time    = as.POSIXct("2016-12-21"),
                            station = seq(257, 262, 0.1))
wldf <- waterLevel(wldf, TRUE)
names(wldf) <- c(names(wldf)[1:5], "WEIGHT_Y")

}
\seealso{
\code{\link[base]{names}}, \code{\link[methods:slot]{slotNames}}
}
