% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-set-convenience.R
\name{set_outer_borders}
\alias{set_outer_borders}
\alias{set_outer_border_colors}
\alias{set_outer_border_styles}
\title{Set borders around a rectangle of cells}
\usage{
set_outer_borders(ht, row, col, value)

set_outer_border_colors(ht, row, col, value)

set_outer_border_styles(ht, row, col, value)
}
\arguments{
\item{ht}{A huxtable.}

\item{row}{A row specifier. See \link{rowspecs} for details.}

\item{col}{An optional column specifier.}

\item{value}{Border width in points, border color, or border style (see \code{\link[=left_border_style]{left_border_style()}}).}
}
\description{
Set borders around a rectangle of cells
}
\details{
\code{set_outer_borders} sets borders round the top, bottom, left and right of a group
of cells. Behaviour is undefined unless \code{row} and \code{col} specify contiguous sequences.
\code{set_outer_border_colors} and \code{set_outer_border_styles} set border colors and styles.
}
\examples{
ht2 <- huxtable(a = 1:3, b = 1:3)
set_outer_borders(ht2, 1)
set_outer_borders(ht2, 2:3, 1:2, 1)

# Problems with colspan:
rowspan(ht2)[2, 1] <- 2
set_outer_borders(ht2, 1:2, 1:2, 1)

}
