% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{label}
\alias{label}
\alias{label<-}
\alias{set_label}
\title{Table label}
\usage{
label(ht)
label(ht) <- value
set_label(ht, value)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A length-one character vector to be used as a table label in LaTeX, or as an ID for the table in HTML. Set to \code{NA} to reset to the default, which is
\code{NA}.}
}
\value{
For \code{label}, the \code{label} property.
For \code{set_label}, the \code{ht} object.
}
\description{
Functions to get or set the table-level \emph{table label} property of a huxtable.
}
\details{
LaTeX table labels typically start with "tab:", and they must do so if you want table numbering
in \href{http://bookdown.org}{bookdown}.
}
\examples{

ht <- huxtable(a = 1:3, b = 1:3)
label(ht) <-  'tab:mytable'
label(ht)

}
