% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{position}
\alias{position}
\alias{position<-}
\alias{set_position}
\alias{position.huxtable}
\alias{position<-.huxtable}
\title{Table position}
\usage{
position(ht)
position(ht) <- value
set_position(ht, value)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A length-one character vector which may be 'left', 'center', 'right' or \code{NA}.}
}
\value{
For \code{position}, the \code{position} attribute.
For \code{set_position}, the \code{ht} object.
}
\description{
Functions to get or set the table-level table position property of a huxtable.
}
\details{
If your tables are too far to the right under LaTeX, try setting their \code{\link[=width]{width()}}
explicitly.
}
\examples{

ht <- huxtable(a = 1:3, b = 1:3)
position(ht) <-  'right'
position(ht)

}
