% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{colspan}
\alias{colspan}
\alias{colspan<-}
\alias{set_colspan}
\alias{colspan.huxtable}
\alias{colspan<-.huxtable}
\title{Get or Set Column Span}
\usage{
colspan(ht)
colspan(ht) <- value
set_colspan(ht, row, col, value)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{An integer vector or matrix of integers. Set to \code{NA} to reset to the default.}

\item{row}{A row specifier.}

\item{col}{A column specifier.}
}
\value{
For \code{colspan}, the \code{colspan} attribute.
For \code{set_colspan}, the \code{ht} object.
}
\description{
Functions to get or set the column span property of huxtable table cells.
}
\examples{

ht <- huxtable(a = 1:3, b = 1:3)
colspan(ht)[1, 1] <-  2
colspan(ht)
print_screen(ht, blank = '.')
}
