% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{col_width}
\alias{col_width}
\alias{col_width<-}
\alias{set_col_width}
\alias{col_width.huxtable}
\alias{col_width<-.huxtable}
\title{Get or Set Column Widths}
\usage{
col_width(ht)
col_width(ht) <- value
set_col_width(ht, col, value)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A vector. If numeric, they are treated as proportions of the table width. If character, they must be valid CSS or LaTeX lengths.}

\item{col}{A col specifier.}
}
\value{
For \code{col_width}, the \code{col_width} attribute.
For \code{set_col_width}, the \code{ht} object.
}
\description{
Functions to get or set the column widths property of huxtable cols.
}
\examples{

ht <- huxtable(a = 1:3, b = 1:3)
col_width(ht) <-  c(.2, .8)
col_width(ht)
print_screen(ht)
}
\seealso{
Other row/column heights: \code{\link{row_height}}
}
