% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{get.exon.annot}
\alias{get.exon.annot}
\title{Get exon names and locations from UCSC}
\usage{
get.exon.annot(dir = NULL, build = NULL, bioC = T, transcripts = FALSE,
  GRanges = TRUE)
}
\arguments{
\item{dir}{character, location to store file with the gene annotation.
If NULL then getOption("save.annot.in.current")>=1 will result in
this file being stored in the current directory, or if <=0, then this file will not
be stored.}

\item{build}{string, currently 'hg18' or 'hg19' to specify which annotation version to use. 
Default is build-36/hg-18. Will also accept integers 36,37 as alternative arguments.}

\item{bioC}{logical, whether to return the annotation as a ranged S4 object (GRanges or
RangedData), or as a data.frame}

\item{transcripts}{logical, if TRUE, return transcripts rather than exons}

\item{GRanges}{logical, if TRUE and bioC is also TRUE, then returned object will be GRanges, otherwise
it will be RangedData}
}
\value{
Returns a data.frame, GRanges or RangedData object, depending on input parameters. Contained
will be HGNC gene labels, chromosome, start and end positions, transcript id number and name
}
\description{
Various R packages assist in downloading exonic information but often the input required is 
complex, or several lines of code are required to initiate, returning an object that
might require some manipulation to be useful. This function simplifies the job 
considerably, not necessarily requiring any arguments. The object returned can be
a standard data.frame or a bioconductor GRanges/RangedData object. The raw annotation
file downloaded will be kept in the working directory so that subsequent calls to
this function run very quickly, and also allow use offline.
}
\examples{
\donttest{
setwd(tempdir())
get.exon.annot()
}
}

