% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fake-http.R
\name{with_fake_HTTP}
\alias{with_fake_HTTP}
\title{Make all HTTP requests return a fake 'response' object}
\usage{
with_fake_HTTP(expr)
}
\arguments{
\item{expr}{Code to run inside the fake context}
}
\value{
The result of \code{expr}
}
\description{
In this context, HTTP verb functions raise a 'message' so that test code can
assert that the requests are made. Unlike \code{\link[=without_internet]{without_internet()}},
the HTTP functions do not error and halt execution, instead returning a
\code{response}-class object so that code calling the HTTP functions can
proceed with its response handling logic and itself be tested.
}
\examples{
with_fake_HTTP({
    expect_GET(req1 <- httr::GET("http://example.com"), "http://example.com")
    req1$url
    expect_POST(req2 <- httr::POST("http://example.com", body='{"a":1}'),
        "http://example.com")
    httr::content(req2)
})
}
