% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/httpgd.R
\name{hgd_close}
\alias{hgd_close}
\title{Close httpgd device.}
\usage{
hgd_close(which = dev.cur(), all = FALSE)
}
\arguments{
\item{which}{Which device (ID).}

\item{all}{Should all running httpgd devices be closed.}
}
\value{
Number and name of the new active device (after the specified device has been shut down).
}
\description{
This achieves the same effect as \code{\link[grDevices:dev]{grDevices::dev.off()}},
but will only close the device if it has the httpgd type.
}
\examples{
\dontrun{

hgd()
hgd_browse() # open browser
hist(rnorm(100))
hgd_close() # Equvalent to dev.off()

hgd()
hgd()
hgd()
hgd_close(all=TRUE)
}
}
