% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_kair.R
\name{calc_kair}
\alias{calc_kair}
\title{Calculate air:matrix partition coefficients}
\usage{
calc_kair(
  chem.cas = NULL,
  chem.name = NULL,
  dtxsid = NULL,
  parameters = NULL,
  species = "Human",
  adjusted.Funbound.plasma = TRUE,
  default.to.human = FALSE,
  suppress.messages = FALSE
)
}
\arguments{
\item{chem.cas}{Chemical Abstract Services Registry Number (CAS-RN) -- if
parameters is not specified then the chemical must be identified by either
CAS, name, or DTXISD}

\item{chem.name}{Chemical name (spaces and capitalization ignored) --  if
parameters is not specified then the chemical must be identified by either
CAS, name, or DTXISD}

\item{dtxsid}{EPA's 'DSSTox Structure ID (\url{https://comptox.epa.gov/dashboard})
 -- if parameters is not specified then the chemical must be identified by 
either CAS, name, or DTXSIDs}

\item{parameters}{Parameters from the appropriate parameterization function
for the model indicated by argument model. Can include parameters "logHenry"
and "body_temp", but if not included standard values are looked up from httk tables.}

\item{species}{Species used for body temperature, defaults to "Human"}

\item{adjusted.Funbound.plasma}{Uses Pearce et al. (2017) lipid binding adjustment
for Funbound.plasma (which impacts partition coefficients) when set to TRUE (Default).}

\item{default.to.human}{Substitutes missing species-specific values with human values if
TRUE (default is FALSE).}

\item{suppress.messages}{Whether or not the output messages are suppressed.}
}
\value{
A named list containing the blood:air, water:air, and mucus:air 
partition coefficients
}
\description{
This function uses the methods colleced by Linakis et al. (2020) to calculate
air partition coefficients for blood, water, and mucus.
}
\details{
The blood:air partition coefficient (PB:A) was calculated as 
\ifelse{html}{\out{P<sub>B:A</sub> = P<sub>B:A</sub> * R<sub>B:P</sub> / f<sub>up</sub>}}{\deqn{P_{B:A} = \frac{P_{B:A} * R_{B:P}}{f_{up}}}}
where P_B:A is the blood:air partition, RB:P is the blood:plasma partition
ratio, fup is the fraction unbound in the plasma, and
P_W:A is the water:air partition coefficient:
\ifelse{html}{\out{R * T<sub>body</sub> / HLC / P}}{\deqn{\frac{R * T_{body}}{HLC * P}}}
where R is the gas constant (8.314 J/mol/K), T_body is the 
species-specific body temperature (K) from \code{\link{physiology.data}},
HLC is the Henry's Law Constant (atm*m^3 / mol), and P is conversion factor 
from atmospheres to Pascals (1 atm = 101325 Pa).

In the isopropanol PBTK
model published by Clewell et al. (2001) it was noted that certain 
chemicals are likely to be absorbed into the mucus or otherwise
trapped in the upper respiratory tract (URT). Following Scott (2014), 
the air:mucus partition coefficient (PA:M) calculated as
\ifelse{html}{\out{log<sub>10</sub>(1/K<sub>water2air</sub>) - (log<sub>10</sub>(P<sub>ow</sub>) - 1) * 0.524}}{\deqn{log_{10}(\frac{1}{K_{water2air}}) - (log_{10}(P_{ow}) - 1) * 0.524}}
where Pow is the octanol/water partition coefficient
}
\references{
Linakis, Matthew W., et al. "Development and evaluation of a 
high throughput inhalation model for organic chemicals." Journal of exposure 
Science & Environmental Epidemiology 30.5 (2020): 866-877.

Clewell III, Harvey J., et al. "Development of a physiologically based 
pharmacokinetic model of isopropanol and its metabolite acetone." 
Toxicological Sciences 63.2 (2001): 160-172.

Scott, John W., et al. "Tuning to odor solubility and sorption pattern in 
olfactory epithelial responses." Journal of Neuroscience 34.6 (2014): 
2025-2036.
}
\author{
John Wambaugh and Matt Linakis
}
\keyword{parameter}
