% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_maternal_bw.R
\name{calc_maternal_bw}
\alias{calc_maternal_bw}
\title{Calculate maternal body weight}
\usage{
calc_maternal_bw(week = 12)
}
\arguments{
\item{week}{Gestational week}
}
\value{
\item{BW}{Maternal Body Weight, kg.}
}
\description{
This function initializes the parameters needed in the functions
solve_fetal_pbtk by calling solve_pbtk and adding additional parameters.
}
\details{
BW <- params$pre_pregnant_BW + 
   params$BW_cubic_theta1 * tw + 
   params$BW_cubic_theta2 * tw^2 + 
   params$BW_cubic_theta3 * tw^3
}
\references{
Kapraun, Dustin F., et al. "Empirical models for anatomical and physiological 
changes in a human mother and fetus during pregnancy and gestation." 
PloS one 14.5 (2019): e0215906.
}
\author{
John Wambaugh
}
\keyword{Parameter}
