\name{httk-package}
\alias{httk-package}
\alias{httk}
\docType{package}
\title{
\packageTitle{httk}
httk: High-Throughput Toxicokinetics
}
\description{
\packageDescription{httk}
Functions and data tables for simulation and statistical analysis of chemical toxicokinetics ("TK") using data obtained from relatively high throughput, in vitro studies. Both physiologically-based ("PBTK") and empirical (e.g., one compartment) "TK" models can be parameterized for several hundred chemicals and multiple species. These models are solved efficiently, often using compiled (C-based) code. A Monte Carlo sampler is included for simulating biological variability and measurement limitations. Functions are also provided for exporting "PBTK" models to "SBML" and "JARNAC" for use with other simulation software. These functions and data provide a set of tools for in vitro-in vivo extrapolation ("IVIVE") of high throughput screening data (e.g., ToxCast) to real-world exposures via reverse dosimetry (also known as "RTK").
}

\author{
Maintainer: \packageMaintainer{httk} 

Robert Pearce <pearce.robert@epa.gov>

Caroline Ring

Nisha Sipes

Jimena Davis

R. Woodrow Setzer

}


\keyword{ package }
\seealso{
Useful links:

https://cfpub.epa.gov/si/si_public_record_report.cfm?dirEntryId=311211

https://www.epa.gov/chemical-research/rapid-chemical-exposure-and-dose-research

https://doi.org/10.1093/toxsci/kfv171

https://doi.org/10.1093/toxsci/kfv118
}                                                                                      
