% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_mc_oral_equiv.R
\name{calc_mc_oral_equiv}
\alias{calc_mc_oral_equiv}
\title{Calculate Monte Carlo Oral Equivalent Dose}
\usage{
calc_mc_oral_equiv(conc, chem.name = NULL, chem.cas = NULL,
  which.quantile = 0.95, species = "Human", input.units = "uM",
  output.units = "mgpkgpday", suppress.messages = F,
  return.samples = F, concentration = "plasma",
  restrictive.clearance = T, bioactive.free.invivo = F,
  tissue = NULL, IVIVE = NULL, ...)
}
\arguments{
\item{conc}{Bioactive in vitro concentration in units of uM.}

\item{chem.name}{Either the chemical name or the CAS number must be
specified.}

\item{chem.cas}{Either the CAS number or the chemical name must be
specified.}

\item{which.quantile}{Which quantile from Monte Carlo steady-state
simulation (calc_mc_css) is requested. Can be a vector. Note that 95th
concentration quantile is the same population as the 5th dose quantile.}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", "Mouse", or
default "Human").}

\item{input.units}{Units of given concentration, default of uM but can also
be mg/L.}

\item{output.units}{Units of dose, default of 'mgpkgpday' for mg/kg BW/ day or
'umolpkgpday' for umol/ kg BW/ day.}

\item{suppress.messages}{Suppress text messages.}

\item{return.samples}{Whether or not to return the vector containing the
samples from the simulation instead of the selected quantile.}

\item{concentration}{Desired concentration type, 'blood','tissue', or default 'plasma'.}

\item{restrictive.clearance}{Protein binding not taken into account (set to
1) in liver clearance if FALSE.}

\item{bioactive.free.invivo}{If FALSE (default), then the total concentration is treated
as bioactive in vivo. If TRUE, the the unbound (free) plasma concentration is treated as 
bioactive in vivo. Only works with tissue = NULL in current implementation.}

\item{tissue}{Desired steady state tissue conentration.}

\item{IVIVE}{Honda et al. (2019) identified six plausible sets of
assumptions for \emph{in vitro-in vivo} extrapolation (IVIVE) assumptions.
Argument may be set to "Honda1" through "Honda6". If used, this function
overwrites the tissue, restrictive.clearance, and plasma.binding arguments.
See Details below for more information.}

\item{...}{Additional parameters passed to calc_mc_css for httkpop and
variance of parameters.}
}
\value{
Equivalent dose in specified units, default of mg/kg BW/day.
}
\description{
This functions converts a chemical plasma concetration to an oral equivalent
dose using a concentration obtained from calc_mc_css.
}
\details{
All arguments after httkpop only apply if httkpop is set to TRUE and species
to "Human".

When species is specified as rabbit, dog, or mouse, the function uses the
appropriate physiological data(volumes and flows) but substitues human
fraction unbound, partition coefficients, and intrinsic hepatic clearance.

Tissue concentrations are calculated for the pbtk model with oral infusion
dosing.  All tissues other than gut, liver, and lung are the product of the
steady state plasma concentration and the tissue to plasma partition
coefficient.

The six sets of plausible \emph{in vitro-in vivo} extrpolation (IVIVE)
assumptions identified by Honda et al. (2019) are: \tabular{lrrrr}{
\tab \emph{in vivo} Conc. \tab Metabolic Clearance \tab Bioactive Chemical
Conc. \tab TK Statistic Used* \cr Honda1 \tab Veinous (Plasma) \tab
Restrictive \tab Free \tab Mean Conc. \cr Honda2 \tab Veinous \tab
Restrictive \tab Free \tab Max Conc. \cr Honda3 \tab Veinous \tab
Non-restrictive \tab Total \tab Mean Conc. \cr Honda4 \tab Veinous \tab
Non-restrictive \tab Total \tab Max Conc. \cr Honda5 \tab Target Tissue \tab
Non-restrictive \tab Total \tab Mean Conc. \cr Honda6 \tab Target Tissue
\tab Non-restrictive \tab Total \tab Max Conc. \cr } *Assumption is
currently ignored because analytical steady-state solutions are currently
used by this function.
}
\examples{


\dontrun{
calc_mc_oral_equiv(0.1,chem.cas="34256-82-1",which.quantile=c(0.05,0.5,0.95),
                   method='vi',samples=100,tissue='brain')
}

}
\references{
Wetmore, Barbara A., et al. "Incorporating high-throughput 
exposure predictions with dosimetry-adjusted in vitro bioactivity to inform 
chemical toxicity testing." Toxicological Sciences 148.1 (2015): 121-136.

Ring, Caroline L., et al. "Identifying populations sensitive to
environmental chemicals by simulating toxicokinetic variability."
Environment international 106 (2017): 105-118. 

Honda, Gregory S., et al. "Using the Concordance of In Vitro and 
In Vivo Data to Evaluate Extrapolation Assumptions." 2019. PLoS ONE 14(5): e0217564.

Rowland, Malcolm, Leslie Z. Benet, and Garry G. Graham. "Clearance concepts in 
pharmacokinetics." Journal of pharmacokinetics and biopharmaceutics 1.2 (1973): 123-136.
}
\author{
John Wambaugh
}
\keyword{Monte-Carlo}
\keyword{Steady-State}
