% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h_wl_di.R
\name{h_wl_di}
\alias{h_wl_di}
\title{Computation of the discharges from water-levels}
\usage{
h_wl_di(fsq, sta, seni, seno, dstart = NA, dend = NA, dbo = TRUE)
}
\arguments{
\item{fsq}{htsr data base}

\item{sta}{Station Id.}

\item{seni}{Input sensor Id (water levels)}

\item{seno}{Output sensor Id (discharges)}

\item{dstart}{Start date (NA by default)}

\item{dend}{End date (NA by default)}

\item{dbo}{Includes the result in the data base (TRUE by default)}
}
\value{
Writes an hts file with the resulting discharges and optionally includes it in the data base.
}
\description{
Computes a discharge time-series from water levels data and calibration curves
}
\details{
Calibration curves must exist in the data base.

If 'dbo' is TRUE, a discharge table "DI" and the sensor 'seno'
must exist in the data base. The new discharge time-series overwrites the already existing data ; however, it is
asked to confirm the operation. In any case the data base is previously backed up.
}
\seealso{
The functions \code{\link{ds_exp_hts}} and \code{\link{d_imp_hts}}are used for export the water levels,
respectively import the discharges within the data base. The function u_exp_discalib
included in \code{\link{p_discalib}} is used for loading the calibration curves.
}
\author{
P. Chevallier - Dec 2020 - Sep 2023
}
