% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d_inventory.R
\name{d_inventory}
\alias{d_inventory}
\title{Inventory of an htsr data base}
\usage{
d_inventory(fsq, sta_sen = NA, form.out = NA)
}
\arguments{
\item{fsq}{Data base file}

\item{sta_sen}{Station_id, with its list of sensors}

\item{form.out}{Display option: NA (console, default) or excel (xlsx) or text (csv; ou csv,)}
}
\value{
Two tables with the inventory of stations and sensors of a data base.
If the output format is an excel file, they are displayed in two sheets
of the same excel file.
}
\description{
The function produces an inventory of the stations and of sensors of an htsr data base.
If only a display is needed, the function \code{\link{ds_inventory}} is more convenient.
}
\details{
If sta_sen is NA (default), all stations and sensors are processed.
If sta_sen is a Station_id, only the sensors of this station are processed.

- form.out can take the following values : NA, "csv," text file with
'.' as decimal separator and ',' as field separator / "csv;"
text file with ',' as decimal separator and ';' as field separator
/ "xlsx" Excel file.
}
\seealso{
\code{\link{ds_inventory}}
}
\author{
P. Chevallier - Jan 2019 - Aug 2023
}
