% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onewaytestClust.R
\name{onewaytestClust}
\alias{onewaytestClust}
\alias{onewaytestClust.default}
\alias{onewaytestClust.formula}
\title{Test for Equal Marginal Means in Clustered Data}
\usage{
onewaytestClust(x, ...)

\method{onewaytestClust}{default}(x, ...)

\method{onewaytestClust}{formula}(formula, id, data, subset, ...)
}
\arguments{
\item{x}{a two-dimensional matrix or data frame containing the within-cluster group means, where rows are the clusters
and columns are the group means.}

\item{...}{further arguments to be passed to or from methods.}

\item{formula}{a formula of the form \code{lhs} ~ \code{rhs}, where \code{lhs} is a numeric variable
giving the data values and \code{rhs} a numeric or factor with two or more levels giving the corresponding groups.}

\item{id}{a vector or factor object denoting cluster membership.}

\item{data}{an optional matrix or data frame containing variables in the formula \code{formula} and \code{id}.
By default the variables are taken from \code{environment(formula)}.}

\item{subset}{an optional vector specifying a subset of observations to be used.}
}
\value{
A list with class "\code{htest}" containing the following components:
\item{statistic}{the value of the test statistic.}
\item{p.value}{the p-value of the test.}
\item{estimate}{the estimated marginal group means.}
\item{parameter}{the degrees of freedom of the chi square distribution.}
\item{method}{a character string indicating the test performed.}
\item{data.name}{a character string giving the name of the data and the total number of clusters.}
\item{M}{the number of clusters.}
}
\description{
Test whether two or more intra-cluster groups have the same marginal means in clustered data. Reweighted to
correct for potential cluster- or group size informativeness.
}
\details{
The null hypothesis is that all levels of \code{group} have equal marginal means.

If \code{x} is a matrix or data frame, the dimension of \code{x} should be MxK, where M is the
number of clusters and K is the number of groups. Each row of \code{x} corresponds to a cluster, where
the column values contain the respective group means from that cluster. Clusters which do not contain
observations in a particular group should have \code{NA} in the corresponding column.
}
\examples{
data(screen8)
## do average reading scores differ across after-school activities?
## test using a table
read.tab <- tapply(screen8$read, list(screen8$sch.id, screen8$activity), mean)
onewaytestClust(read.tab)

## test using formula method
onewaytestClust(read~activity, id=sch.id, data=screen8)

}
\references{
Gregg, M., Marginal methods and software for clustered data with cluster- and group-size informativeness.
PhD dissertation, University of Louisville, 2020.
}
