% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postestimation.R
\name{posterior_predict.hsstan}
\alias{posterior_predict.hsstan}
\alias{posterior_predict}
\title{Posterior predictive distribution}
\usage{
\method{posterior_predict}{hsstan}(object, newdata = NULL,
  nsamples = NULL, seed = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{hsstan}.}

\item{newdata}{Optional data frame containing the variables to use to
predict. If \code{NULL} (default), the model matrix is used. If
specified, its continuous variables should be standardized, since
the model coefficients are learnt on standardized data.}

\item{nsamples}{A positive integer indicating the number of posterior samples
to use. If \code{NULL} (default) all samples are used.}

\item{seed}{Optional integer defining the seed for the pseudo-random number
generator.}

\item{...}{Currently ignored.}
}
\value{
A matrix of size \code{S} by \code{N}, where \code{S} is the number of simulations from
the posterior predictive distribution, and \code{N} is the number of data points.
}
\description{
Draw from the posterior predictive distribution of the outcome.
}
\examples{
\dontshow{utils::example("hsstan", echo=FALSE)}
# continued from ?hsstan
posterior_predict(hs.biom)

}
