% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hglm.R
\name{hglm_fit}
\alias{hglm_fit}
\title{Fitting Holistic Generalized Linear Models}
\usage{
hglm_fit(
  model,
  constraints = NULL,
  big_m,
  solver = "auto",
  control = list(),
  dry_run = FALSE
)
}
\arguments{
\item{model}{a 'HGLM' model (object of class \code{"hglm_model"}).}

\item{constraints}{a list of 'HGLM' constraints stored in a list of class \code{"lohglmc"}.}

\item{big_m}{an upper bound for the coefficients, needed for the big-M constraint.
Required to inherit from \code{"hglmc"}. Currently constraints created by
\code{group_sparsity()}, \code{group_inout()},
\code{include()} and \code{group_equal()} use the big-M set here.}

\item{solver}{a character string giving the name of the solver to be used for the estimation.}

\item{control}{a list of control parameters passed to \code{ROI_solve}.}

\item{dry_run}{a logical if \code{TRUE} the model is not fit but only constructed.}
}
\value{
an object of class \code{"hglm.fit"} inheriting from \code{"glm"}.
}
\description{
Fit a generalized linear model under constraints.
}
\examples{
dat <- rhglm(100, c(1, 2, -3, 4, 5, -6))
x <- model.matrix(y ~ ., data = dat)
model <- hglm_model(x, y = dat[["y"]])
fit <- hglm_fit(model, constraints = k_max(3))
}
