% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.R
\name{group_sparsity}
\alias{group_sparsity}
\title{Group Sparsity Constraint}
\usage{
group_sparsity(vars, k = 1L)
}
\arguments{
\item{vars}{a vector specifying the indices or names of the covariates to which the group constraint 
shall be applied.}

\item{k}{an integer giving the maximum number of covariates to be included in the model from the specified group.}
}
\value{
A holistic generalized model constraint, object inheriting from class \code{"hglmc"}.
}
\description{
Constraint which restricts the number of covariates selected from a specific group.
}
\examples{
dat <- rhglm(100, c(1, 2, 0, 4, 5, 0))
constraints <- group_sparsity(c("x1", "x2", "x5"), 1L)
hglm(y ~ ., constraints = constraints, data = dat)
}
\seealso{
Other Constraint-Constructors: 
\code{\link{group_equal}()},
\code{\link{group_inout}()},
\code{\link{include}()},
\code{\link{k_max}()},
\code{\link{linear}()},
\code{\link{lower}()},
\code{\link{pairwise_sign_coherence}()},
\code{\link{rho_max}()},
\code{\link{sign_coherence}()},
\code{\link{upper}()}
}
\concept{Constraint-Constructors}
